/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Frank	3/1/05			CHANGED_BOXES_TO_SPLITTER_AND_ADD_FILTER			*
 * DG 3/11/05 v8.0202 FB_STRUCTURE_REWRITE										*
 * DG 3/25/05 v8.0211 COMMENT_NOT_FINISH_FOR_ALPHA3								*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
#include "DialogEx.h"
#include "TreeEditSplitter.h"

#include <Profiler.h>
#define HOUR_GLASS			waitCursor junk;
#define _SHOW_TIME			Profiler junk;

//#include "FBCache.h" ///Forest 4/5/05 no need cache now
#include "FBFilter.h"	///DG 3/17/05
#include "FBFunctionList.h"
//#include "FunctionBrwList.h"	///DG 3/28/05 no use now
#include "FunctionBrowser.h"

#define STR_DLG_NAME "Function Browser"
#define	STR_FB_SELECTIONS	"User Selections"
#define	CHAR_FB_SELECTIONS_SEP '|'

//void OpenFB()	//only for test
//{
	//FBopen();	
//}
string FBopen(HWND hParent = NULL)	//modal dialog, called from xf-dialog
{
	string strEmpty;
	FunctionBrowserDlg  FBDlg;
	Window winDlg = FBDlg.GetWindow();
	if(winDlg)
	{
		out_str("Function Browser Dialog already open");
		return strEmpty;
	}
	if(NULL == hParent)
		hParent=GetWindow();
	int nRet=FBDlg.DoModal( hParent ); 
	if(IDOK == nRet)
		return FBDlg.GetFunction();
	return strEmpty;
}

///---DG 3/28/05 static dialog call from CB, etc
static FunctionBrowserDlg s_FBDlg;
bool OpenFB()
{
	Window winDlg = s_FBDlg.GetWindow();
	if(winDlg)
	{
		out_str("Dialog already open");
		return false;
	}
	int nRet = s_FBDlg.Create(GetWindow());
	return true;
}
///---end
void FunctionBrowserDlg::LoadCateListToCombo(LPCSTR lpcSelected)
{
	//now we use hard code to generate category list
	//later will use a xml to store category list if many categories
	vector<string> vsCategoryList =
		{"Analysis", "Analysis>Spectral Analysis", "Basic I/O", "Character/String Manipulation",
		"Communications", "Complex Numbers", "Date Time", "File I/O", "File Management",
		"Font", "Graph Window", "Image", "Import Export", "LabTalk Interface", 
		"Layer and Page", "Mathematical", "Memory Management", "miscellaneous",
		"Note Window", "Operation", "Origin System", "Statistics", "System",
		"Tree", "User Interface", "Workbook"};
	vsCategoryList.InsertAt(0, STR_ALL_CATEGORY);
	for(int ii = 0; ii < vsCategoryList.GetSize(); ii++)
		m_cmboxCateList.AddString(vsCategoryList[ii]);
	int i1 = vsCategoryList.Find(lpcSelected);
	if(i1 >= 0)
		m_cmboxCateList.SetCurSel(i1);
}

void FunctionBrowserDlg::LoadFilterListToCombo(LPCSTR lpcDispName)
{
	vector<string> vsThemeList;
	Tree	tr;
	tr.SetAttribute(STR_THEME_TYPE_ATTRIB, THTYPE_FB_FILTER);
	tr.SetAttribute(STR_CLASS_OPTION_NAME_ATTRIB, STR_FB_THEME_CLASS);
	theme_get_list(tr, vsThemeList);//get theme lists
	vsThemeList.InsertAt(0, STR_NO_FILTER);
	m_cmboxFilterList.ResetContent();
	for(int ii = 0; ii < vsThemeList.GetSize(); ii++)
		m_cmboxFilterList.AddString(vsThemeList[ii]);
	int i1 = vsThemeList.Find(lpcDispName);
	if(i1 >= 0)
		m_cmboxFilterList.SetCurSel(i1);
}

bool FunctionBrowserDlg::OnInitDialog()
{
	HOUR_GLASS	///DG 3/11/05
	
	vector<string>  vstrTipsUpDown = {"Show detail", "Hide detail"};
	MultiPaneDlg::OnInitDialog(IDC_FB_FUNCTION_LIST, IDC_FB_SHOW_DETAIL, IDC_FB_DETAIL_REDIT, vstrTipsUpDown, STR_DLG_NAME);
	
	m_List.Init(IDC_FB_FUNCTION_LIST, *this);
	GetItem(IDC_FB_CATEGORY_SELECT_BTN).Enable=false;	//later, we support category selection
	///Forest 4/5/05 SAVE_AND_LOAD_USE_SELECTION
	/*
	m_cmboxCateList=GetItem(IDC_FB_CATEGORY_COMB);
	LoadCateListToCombo();
	m_cmboxCateList.SetCurSel(0);//set "all categories"
	m_List.SelectCate(STR_ALL_CATEGORY);
	m_cmboxFilterList=GetItem(IDC_FB_FILTER_COMB);
	LoadFilterListToCombo();
	m_cmboxFilterList.SetCurSel(0);//set "no filter"
	m_List.SelectFilter(STR_NO_FILTER);
	m_rchDetail=GetItem(IDC_FB_DETAIL_REDIT);
	m_edSearch=GetItem(IDC_FB_SEARCH_ED);
	*/
	m_cmboxCateList=GetItem(IDC_FB_CATEGORY_COMB);
	m_cmboxFilterList=GetItem(IDC_FB_FILTER_COMB);
	m_rchDetail=GetItem(IDC_FB_DETAIL_REDIT);
	m_edSearch=GetItem(IDC_FB_SEARCH_ED);
	loadSelections();//load user selections last time
	///End SAVE_AND_LOAD_USE_SELECTION
	UpdateDlgSize();
	UpdateDlgShow();

	SetInitReady();
	return true;
}
///Forest 4/5/05 SAVE_AND_LOAD_USE_SELECTION
void FunctionBrowserDlg::OnDestroy()
{
	saveSelections();
}
///End SAVE_AND_LOAD_USE_SELECTION
bool FunctionBrowserDlg::OnDlgResize(int nType, int cx, int cy)
{
	if(!IsInitReady())
		return TRUE;
	
	uint nButtonIDs[] = {IDCANCEL, IDOK, 0};
	MultiPaneDlg::OnDlgResize(nButtonIDs, cx, cy, false);
	
	repositionControl(cx, cy);
	return TRUE;
}
bool FunctionBrowserDlg::OnInsert()
{
	m_strInsertFunction = m_List.GetFunction();
	if(m_strInsertFunction.IsEmpty())
		return false;
	return true;
}
bool FunctionBrowserDlg::OnClickSelectCate(Control ctrl)
{
	//later, when they are so much category, we will support category selection
	return true;
}
bool FunctionBrowserDlg::OnClickFilter(Control ctrl)
{
	HOUR_GLASS
	//when click cancel after opening filter GUI, just need update themes
	if(!m_List.OpenFilter(m_cmboxFilterList.Text))
	{
		LoadFilterListToCombo(m_cmboxFilterList.Text);
		return	false;
	}
	//otherwise
	m_edSearch.Text.Empty();
	OnClickSearchFunction(ctrl);
	//update filter list
	string strDispName;
	if(m_List.GetSelectedFilterName(strDispName))
		LoadFilterListToCombo(strDispName);
	else
		LoadFilterListToCombo();
	return true;
}
bool FunctionBrowserDlg::OnClickSearchFunction(Control ctrl)
{
	HOUR_GLASS
	string strText = m_edSearch.Text;
	m_List.SearchFunctions(strText);
	m_List.UpdateList();///Forest 04/06/05 UPDATE_ONLY_ONCE
	return true;
}
bool FunctionBrowserDlg::OnCategoryChange(Control ctrl)
{
	HOUR_GLASS
	string	strText = m_cmboxCateList.Text;
	m_List.SelectCate(strText);
	m_cmboxFilterList.SetCurSel(0);//STR_NO_FILTER
	return OnFilterChange(ctrl);
}
bool FunctionBrowserDlg::OnFilterChange(Control ctrl)
{
	HOUR_GLASS
	string	strText = m_cmboxFilterList.Text;
	m_List.SelectFilter(strText);
	m_edSearch.Text.Empty();
	return	OnClickSearchFunction(ctrl);
}
void FunctionBrowserDlg::OnRowChange(Control ctrl)
{
	if(!IsInitReady())
		return;
	m_List.OnRowChange(m_List.GetSelectedRow());
	if(IsBottomPaneShown())
		updateFunctionDetail();
}
void FunctionBrowserDlg::OnMouseMoveList(Control ctrl, short nButton, short nShift, float X, float Y)
{
	int nRow, nCol;
	m_List.GetMouseCell(nRow, nCol);
	m_List.OnShowTips(nRow);
}

void FunctionBrowserDlg::repositionControl(int cx, int cy)
{
	RECT rr;
	Control cBox;
	GetControlClientRect(IDC_FB_FUNCTION_LIST, rr, &cBox);
	
	int nEdge=GetControlGap(), nx=nEdge, ny=nEdge;
	//ny=ArrangeControlsLeftRight(m_vnCategoryGroup, nx, ny)+nEdge;
	ny=ResizeDialog::ArrangeControlsLeftRight(m_vnCategoryGroup, nx, ny, cx, IDC_FB_CATEGORY_COMB, nEdge)+nEdge;
	ny=ResizeDialog::ArrangeControlsLeftRight(m_vnFilterGroup, nx, ny, cx, IDC_FB_FILTER_COMB, nEdge)+nEdge;
	ny=ResizeDialog::ArrangeControlsLeftRight(m_vnSearchGroup, nx, ny, cx, IDC_FB_SEARCH_ED, nEdge)+nEdge;
	
	rr.top=ny;
	cBox.MoveWindow(&rr);
}
void FunctionBrowserDlg::updateFunctionDetail()
{
	string strDetail=m_List.GetCurrentDetail();
	m_rchDetail.Text=strDetail;
}

bool FunctionBrowserDlg::OnShowBottomPane(Control ctrl)
{
	MultiPaneDlg:: OnShowBottomPane(ctrl);
	updateFunctionDetail();
	return	true;
}

///Forest 4/5/05 SAVE_AND_LOAD_USE_SELECTION
bool FunctionBrowserDlg::saveSelections()
{
	vector<string> vsSel(3);
	vsSel[0] = m_cmboxCateList.Text;
	vsSel[1] = m_cmboxFilterList.Text;
	vsSel[2] = m_edSearch.Text;
	string strVal;
	strVal.SetTokens(vsSel, CHAR_FB_SELECTIONS_SEP);
	SaveSetting(STR_FB_SELECTIONS, strVal, STR_DLG_NAME);
	return	true;
}
bool FunctionBrowserDlg::loadSelections()
{
	string strVal;
	vector<string> vsSel(3);
	if(LoadSetting(STR_FB_SELECTIONS, strVal, STR_DLG_NAME))
		strVal.GetTokens(vsSel, CHAR_FB_SELECTIONS_SEP);
	else
	{
		vsSel[0] = STR_ALL_CATEGORY;
		vsSel[1] = STR_NO_FILTER;
		vsSel[2] = "";
	}
	LoadCateListToCombo(vsSel[0]);
	m_List.SelectCate(vsSel[0]);
	LoadFilterListToCombo(vsSel[1]);
	m_List.SelectFilter(vsSel[1]);
	m_edSearch.Text = vsSel[2];
	Control ctrl;
	return	OnClickSearchFunction(ctrl);
}
///End SAVE_AND_LOAD_USE_SELECTION